//
//  Material.vsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//

#ifdef OGL_ES2
#	ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#		define prec_high highp
#	else
precision mediump float;
#		define prec_high mediump
#	endif
#	define prec_med	mediump
#	define prec_low	lowp
#else 
#	define prec_high
#	define prec_med 
#	define prec_low 
#endif

#if defined(ENABLE_COLOR) && defined(ENABLE_ALPHA)
varying prec_low vec4 v_color;
attribute prec_low vec4 a_color;
#elif defined(ENABLE_COLOR)
varying prec_low vec3 v_color;
attribute prec_low vec3 a_color;
#elif defined(ENABLE_ALPHA)
varying prec_low float v_color;
attribute prec_low float a_color;
#endif


#ifdef ENABLE_TEXTURE0
attribute prec_med vec2 a_texture0_coords;
varying prec_med vec2 v_texture0_coord;
#endif

#ifdef ENABLE_TEXTURE1
attribute prec_med vec2 a_texture1_coords;
varying prec_med vec2 v_texture1_coord;
#endif

#ifdef ENABLE_TEXTURE0_MATRIX
uniform mat4 u_texture0_matrix;
#endif

#ifdef ENABLE_PROJECTEDLIGHT0
uniform prec_med mat4 u_projected0_matrix;
varying prec_med vec4 v_projected0_coord;
#endif


#ifdef ENABLE_SHADOWMAP0
varying prec_high vec4  v_shadowMap0_coord;
varying prec_high float v_shadowMap0_distance;
uniform prec_high mat4  u_shadowMap0_matrix;
uniform prec_med float u_shadowMap0_intensity;
uniform prec_med vec3  u_shadowMap0_position;
#endif
#ifdef ENABLE_SHADOWMAP1
varying prec_med vec4  v_shadowMap1_coord;
varying prec_high float v_shadowMap1_distance;
uniform prec_med mat4  u_shadowMap1_matrix;
uniform prec_med float u_shadowMap1_intensity;
uniform prec_med vec3  u_shadowMap1_position;
#endif
#ifdef ENABLE_SHADOWMAP2
varying prec_med vec4  v_shadowMap2_coord;
varying prec_high float v_shadowMap2_distance;
uniform prec_med mat4  u_shadowMap2_matrix;
uniform prec_med float u_shadowMap2_intensity;
uniform prec_med vec3  u_shadowMap2_position;
#endif
#ifdef ENABLE_SHADOWMAP3
varying prec_med vec4  v_shadowMap3_coord;
varying prec_high float v_shadowMap3_distance;
uniform prec_med mat4  u_shadowMap3_matrix;
uniform prec_med float u_shadowMap3_intensity;
uniform prec_med vec3  u_shadowMap3_position;
#endif


#ifdef ENABLE_LIGHTMAP
attribute prec_med vec2 a_lightMap_coords;
varying prec_med vec2 v_lightMap_coord;
#endif

#ifdef ENABLE_RIMLIGHT_PER_VERTEX
varying prec_low vec3 v_rimLight;
uniform prec_low vec4 u_rimColor;
uniform prec_low float u_rimExponent;
#endif

#ifdef ENABLE_RIMLIGHT_PER_PIXEL
uniform prec_low vec4 u_rimColor;
#endif


#if defined(ENABLE_FOG_LINEAR) || defined(ENABLE_FOG_EXPONENTIAL) || defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
#	if defined(ENABLE_FOG_EXPONENTIAL) || defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
uniform prec_high float u_fogDensity;
#	else
uniform prec_high float u_fogEnd;
uniform prec_high float u_fogReciprocalEndStartDelta;
#	endif
varying prec_low vec3  v_fogIntensity;
#endif

#if defined(ENABLE_ALPHATEST)
uniform prec_low float u_alphaTestValue;
#endif

#if defined(ENABLE_PARALLAXMAP)
varying prec_high vec3 v_tangentSpace_eye;
#endif

#if defined(ENABLE_ENVIRONMENTCUBEMAP)
varying prec_high vec3 v_environmentCubeMapCoords;
#endif

// dependency includes

#ifdef DEPENDENCY_MATRIX_MODELVIEW
uniform mat4 u_modelviewMatrix;
#endif


#ifdef DEPENDENCY_MATRIX_MODEL
uniform mat4 u_modelMatrix;
#endif

#ifdef DEPENDENCY_MATRIX_MODELROTATION
uniform mat3 u_modelRotationMatrix;
#endif

#ifdef DEPENDENCY_MATRIX_VIEW
uniform mat4 u_viewMatrix;
#endif

#ifdef DEPENDENCY_OBJECTSPACE_EYE
uniform prec_med vec3 u_objectSpace_eye;
#endif

#ifdef DEPENDENCY_WORLDSPACE_EYE
uniform prec_med vec3 u_worldSpace_eye;
#endif

#ifdef DEPENDENCY_NORMALS
attribute prec_med vec4 a_normal;
varying prec_med vec3 v_normal;
#endif

#ifdef DEPENDENCY_TANGENTS
attribute prec_med vec3 a_tangent;
varying prec_med vec3 v_tangent;
#endif

#ifdef DEPENDENCY_OBJECTSPACE_POSITION
varying prec_med vec3 v_objectSpace_position;
#endif

#ifdef DEPENDENCY_EYE_VERTEX_DIRECTION
varying prec_high vec3 v_xyz_view_dir;
#endif

#if !defined(ENABLE_SCREENSPACE_VERTICES)
uniform mat4 u_modelviewProjectionMatrix;
#endif

// NOTE: these are always required
attribute vec4 a_position;

//void CalcShadowMap(in mat4 shadowMap_matrix, in vec3 shadowMap_position, in float shadowMap_intensity,
//                   out vec4 shadowMap_coord, out float shadowMap_distance )
//{
//    shadowMap_coord = shadowMap_matrix * a_position;
//    
//	prec_high vec3 dist = shadowMap_position - a_position.xyz;
//		
//    shadowMap_distance = 1.0 - clamp( length(dist) / shadowMap_intensity , 0.0, 1.0);
//}

void main()
{
#if defined(ENABLE_SCREENSPACE_VERTICES)
	gl_Position = a_position;
#else
	gl_Position = u_modelviewProjectionMatrix * a_position;
#endif
	
#if defined(ENABLE_COLOR) || defined(ENABLE_ALPHA)
	v_color = a_color;
#endif
	
#ifdef DEPENDENCY_NORMALS
	v_normal = a_normal.xyz;
#endif
	
#ifdef DEPENDENCY_TANGENTS
//	vec3 a_bitangent = cross(a_normal.xyz, a_tangent);
	vec3 a_bitangent = cross(a_tangent, a_normal.xyz);
	v_tangent = a_tangent;
#endif 
#ifdef DEPENDENCY_EYE_VERTEX_DIRECTION
	// NOTE: view direction has to be normalized in the fragment shader!
	v_xyz_view_dir = (a_position.xyz - u_objectSpace_eye);
#endif

#ifdef ENABLE_PARALLAXMAP
	// NOTE: view direction has to be normalized in the fragment shader!
	prec_high mat3 objectSpaceToTangentSpace = mat3(a_tangent, a_bitangent, v_normal);
	v_tangentSpace_eye = v_xyz_view_dir * objectSpaceToTangentSpace;
#endif
	
#ifdef ENABLE_TEXTURE0
#   if defined(ENABLE_TEXTURE0_MATRIX)
    v_texture0_coord = (u_texture0_matrix * vec4(a_texture0_coords,1.0,1.0)).st;
#   else
	v_texture0_coord = a_texture0_coords;
#   endif
#endif
	
#ifdef ENABLE_TEXTURE1
	v_texture1_coord = a_texture1_coords;
#endif
    
#ifdef ENABLE_LIGHTMAP
    v_lightMap_coord = a_lightMap_coords;
#endif
	
#ifdef ENABLE_RIMLIGHT_PER_VERTEX
	prec_low float rimDot = dot(normalize(v_xyz_view_dir), a_normal.xyz) + 1.0;
	prec_low float rimValue = pow(rimDot, u_rimExponent) * u_rimColor.a;
	v_rimLight = u_rimColor.rgb * rimValue;
#endif

#if defined(ENABLE_FOG_LINEAR) || defined(ENABLE_FOG_EXPONENTIAL) || defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
	// transform position to view space as we need the distance to the eye for fog
	prec_high vec3 viewPos = (u_modelviewMatrix * a_position).xyz;
	prec_high float eyeDist = length(viewPos);
	prec_high float fogIntensity = 1.0;
#	if defined(ENABLE_FOG_LINEAR)
		fogIntensity = (u_fogEnd - eyeDist) * u_fogReciprocalEndStartDelta;
#	else if defined(ENABLE_FOG_EXPONENTIAL) || defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
		prec_high float scaledDist = eyeDist * u_fogDensity;
#		if defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
			scaledDist *= scaledDist;
#		endif
		fogIntensity = exp2(-scaledDist);
#	endif
	// clamp the intensity within a valid range
	v_fogIntensity = vec3(clamp(fogIntensity, 0.0, 1.0));
#endif


#if defined(ENABLE_ENVIRONMENTCUBEMAP)
	v_environmentCubeMapCoords = u_modelRotationMatrix * reflect(normalize(v_xyz_view_dir.xyz), a_normal.xyz);
#endif

#ifdef DEPENDENCY_OBJECTSPACE_POSITION
	v_objectSpace_position = a_position.xyz;
#endif
    
#ifdef ENABLE_PROJECTEDLIGHT0
    v_projected0_coord = u_projected0_matrix * a_position;
#endif
	
#ifdef ENABLE_SHADOWMAP0
	{
		v_shadowMap0_coord = u_shadowMap0_matrix * a_position;
		prec_high vec3 dist = u_shadowMap0_position - a_position.xyz;
		v_shadowMap0_distance = 1.0 - clamp( length(dist) / u_shadowMap0_intensity , 0.0, 1.0);
	}
#endif	
#ifdef ENABLE_SHADOWMAP1
    CalcShadowMap(u_shadowMap1_matrix, u_shadowMap1_position, u_shadowMap1_intensity, v_shadowMap1_coord, v_shadowMap1_distance);
#endif
#ifdef ENABLE_SHADOWMAP2
    CalcShadowMap(u_shadowMap2_matrix, u_shadowMap2_position, u_shadowMap2_intensity, v_shadowMap2_coord, v_shadowMap2_distance);
#endif
#ifdef ENABLE_SHADOWMAP3
    CalcShadowMap(u_shadowMap3_matrix, u_shadowMap3_position, u_shadowMap3_intensity, v_shadowMap3_coord, v_shadowMap3_distance);
#endif
}

